model Ex13_2
//Parameter Section
parameter Real MA(unit = "g/gmole") = 16.04 "Molecular weight of Methane";
parameter Real MB(unit = "g/gmole") = 32 "Molecular weight of Ethane";
parameter Real sigma_A(unit = "Angstrom") = 3.822 "Characteristic length parameter";
parameter Real sigma_B(unit = "Angstrom") = 4.418 "Characteristic length parameter";
parameter Real P(unit = "atm") = 1 "Total pressure";
parameter Real T_F(unit = "F") = 104 "Temperature in F";
parameter Real omegaD_AB(unit = "nil") = 1.125 "Collision Integral";
parameter Real epsilon_A_by_K(unit = "K") = 137;//epsilon-energy of molcular attraction; K-Boltzmann's constant
parameter Real epsilon_B_by_K(unit = "K") = 230;//epsilon-energy of molcular attraction; K-Boltzmann's constant
//==========================================================================================================
//Variable Section 
Real epsilon_AB_by_K(unit = "K");//epsilon-energy of molcular attraction; K-Boltzmann's constant
Real KT_by_epsilon_AB(unit = "nil") "Collision function";
Real sigma_AB(unit = "Angstrom") "Characteristic length parameter of binary mixture AB";
Real T_K(unit = "K") "Temperature in K";
Real D_AB(unit = "cm^2/s") "Diffusivity";
//==========================================================================================================
//Equation Section
equation 
T_K = (T_F+459.7)/1.8;
epsilon_AB_by_K = sqrt(epsilon_A_by_K*epsilon_B_by_K);
KT_by_epsilon_AB = T_K/epsilon_AB_by_K;
sigma_AB = (sigma_A+sigma_B)/2;
D_AB = (0.0018583*sqrt(T_K^3*((1/MA)+(1/MB))))/(P*sigma_AB^2*omegaD_AB);
//Chapman Enskog equation 
end Ex13_2;
