model Ex13_4
//Parameter Section
parameter Real MA(unit = "g/gmole") = 39.94 "Molecular weight of Argon";
parameter Real MB(unit = "g/gmole") = 32 "Molecular weight of Oxygen";
parameter Real P(unit = "atm") = 1 "Total Pressure of the system";
parameter Real Pc_A(unit = "atm") = 48 "Critical Pressure for Argon";
parameter Real Pc_B(unit = "atm") = 49.7 "Critical Pressure for Oxygen";
parameter Real T(unit = "K") = 293.2 "Absolute temperature";
parameter Real Tc_A(unit = "K") = 151.2 "Critical Temperature for Argon";
parameter Real Tc_B(unit = "K") = 154.4 "Critical Temperature for Argon";
parameter Real a(unit = "nil") = 2.745*10^(-4) "constant";
parameter Real b(unit = "nil") = 1.823 "constant";
//For non-polar gas pairs
//============================================================================
//Variable Section
Real D_AB(unit = "cm^2/s") "Diffusivity for Argon-Oxygen system";
//============================================================================
//Equation Section
equation
(P*D_AB)/((Pc_A*Pc_B)^(1/3)*((Tc_A*Tc_B)^(5/12))*(((1/MA)+(1/MB))^(1/2))) = (a*(T/(sqrt(Tc_A*Tc_B)))^b); 
//Slattery-Bird Equation
end Ex13_4;
