model Ex13_5
//Parameter Section
parameter Real Tc_A(unit = "K") = 190.7 "Critical Temperature of methane";
parameter Real Tc_B(unit = "K") = 305.4 "Critical Temperature of ethane";
parameter Real Pc_A(unit = "atm") = 45.8 "Critical Pressure of methane";
parameter Real Pc_B(unit = "atm") = 48.2 "Critical Pressure of ethane";
parameter Real T1(unit = "K") = 313 "Temperature of the mixture";
parameter Real P(unit = "atm") = 136 "Pressure of the mixture";
parameter Real T2(unit = "K") = 293 "Temperature of the mixture";
parameter Real D_AB_T2(unit = "cm^2/s") = 0.163  "Diffusivity of the mixture at 293 K";
parameter Real b(unit = "nil") = 1.823 "Constant"; //For non polar gases
parameter Real PD_AB_by_PD_AB0(unit = "nil") = 0.73 "Ratio of diffusivities";
//===========================================================================================
//Variable Section
Real PD_AB_T1(unit = "atm.cm^2/s") "Diffusivity at 313 K";
Real Pc(unit = "atm") "Pseudo critical Pressure";
Real Tc(unit = "K") "Pseudo critical Temperature";
Real Pr(unit = "nil") "Pseudo reduced pressure";
Real Tr(unit = "nil") "Pseudo reduced temperature";
Real D_AB(unit = "cm^2/s") "Mass diffusivity for a mixture of 80 mole percent methane and 
20 mole percent ethane";
//===========================================================================================
//Equation Section
equation
PD_AB_T1 = D_AB_T2*(T1/T2)^b;
Pc = (0.8*Pc_A)+(0.2*Pc_B);
Tc = (0.8*Tc_A)+(0.2*Tc_B);
Pr = P/Pc;
Tr = T1/Tc;
D_AB = (PD_AB_T1/P)*PD_AB_by_PD_AB0;
end Ex13_5;
