model Ex14_10
//Parameter Section
parameter Real D_AB(unit = "m^2/s") = 6.92*10^(-6) "Diffusivity of naphthalene in air";
parameter Real Ps_A1(unit = "mmHg") = 0.555 "Vapour Pressure of naphthalene at 318 K";
parameter Real p_A2(unit = "N/m^2") = 0 "Partial pressure of naphthalene at point 2"; //since it is pure air
parameter Real P_atm(unit = "mmHg") = 760 "Atmospheric pressure in mmHg";
parameter Real P_T(unit = "N/m^2") = 1.013*10^5 "Total Pressure of the system";
parameter Real T(unit = "K") = 318 "Temperature of the system";
parameter Real r(unit = "m") = 2*10^(-3) "Radius of the naphthalene ball";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
//===========================================================================================================
//Variable Section
Real p_A1(unit = "N/m^2") "Partial pressure of naphthalene";
Real p_B1(unit = "N/m^2") "Partial pressure of air at point 1";
Real p_B2(unit = "N/m^2") "Partial pressure of air at point 2";
Real p_B_lm(unit = "N/m^2") "Logarithmic mean partial presssure";
Real NA(unit = "kmoles/s.m^2") "Flux of diffusion of naphthalene into stagnant air";
Real Rate(unit = "kmole/s") "Rate of evaporation of naphthalene";
//===========================================================================================================
//Equation Section
equation
p_A1 = (Ps_A1/P_atm)*P_T;
p_B1 = P_T-p_A1;
p_B2 = P_T-p_A2;
p_B_lm = (p_B1+p_B2)/2; //Since p_B1 is close to p_B2, linear mean is used
NA = (D_AB*P_T*(p_A1-p_A2))/(R*T*r*p_B_lm);
Rate = NA*4*3.14*(r^2);
end Ex14_10;
//The last part of the solution provided in the textbook has no relation with that in the question
//The coding has been done till rate of evaporation of naphthalene
