model Ex2_5
//Parameter Section
parameter Real N(unit = "gmol^(-1)") = 6.023*10^23 "Avagadro number";
parameter Real V(unit = "cm^3/gmole") = 18 "Molar volume";
parameter Real h(unit = "g.cm^2/s") = 6.624*10^(-27) "Planck's constant";
parameter Real T_1(unit = "K") = 273 "Temperature of the saturated liquid water";
parameter Real T_2(unit = "K") = 373 "Temperature of the saturated liquid water";
parameter Real Tb(unit = "K") = 373 "Boiling point of water";
//===================================================================================
//Variable Section
Real mu_1(unit = "g/cm.s") "Viscosity of saturated liquid water at T_1";
Real mu_1_cP(unit = "cP") "Viscosity of saturated liquid water at T_2 in cP";
Real mu_2(unit = "g/cm.s") "Viscosity of saturated liquid water at T_1";
Real mu_2_cP(unit = "cP") "Viscosity of saturated liquid water at T_2 in cP";
//===================================================================================
//Equation Section 
equation
mu_1 = (N*h*exp((3.8*Tb)/T_1))/V;
mu_2 = (N*h*exp((3.8*Tb)/T_2))/V;
mu_1_cP = mu_1*10^(2);
mu_2_cP = mu_2*10^(2);
end Ex2_5;
