model Ex2_7
//Parameter section
parameter Real mu(unit = "cP") = 1 "Viscosity of the fluid";
parameter Real delVz(unit = "m/s") = 1 "Difference in velocity";
parameter Real dely(unit = "m") = 1*10^(-3) "Distance between the plates";
//==============================================================================
//Variable Section
Real tau(unit = "N/m^2") "Shear stress";
//==============================================================================
//Equation Section
equation
tau = (((mu*10^(-2)*10^(-3))/10^(-2))*delVz)/dely; //1 kg = 1000 g and 1 m = 100 cm // centi = 10^(-2)
end Ex2_7;
