model Ex3_1
//Parameter Section
parameter Real D(unit = "m") = 5.08*10^(-2) "Diameter of the pipe";
parameter Real L(unit = "m") = 3.048 "Length of the pipe";
parameter Real delP(unit = "N/m^2") = 6.89*10^4 "Pressure drop over the pipe" ;
parameter Real mu(unit = "N.s/m^2") = 200*10^(-3) "Viscosity of oil";
parameter Real rho(unit = "kg/m^3") = 800 "Density of the oil";
//==========================================================================
//Variable Section
Real R(unit = "m") "Radius of the pipe";
Real Q(unit = "m^3/s") "Volumetric flow rate in m^3/s";
Real Q_litrepermin(unit = "lit/min") "Volumetric flow rate in litre/min";
Real Re(unit = "nil") "Reynolds number";
Real tau_rz(unit = "N/m^2") "Momentum flux";
//==========================================================================
//Equation Section
equation
R = D/2;
Q = (3.14*delP*R^4)/(8*mu*L); //Laminar flow is assumed // Hagen-Poiseuille equation
Q_litrepermin = Q*1000*60; //1 m^3 = 1000 L //1 min = 60 sec 
Re = (4*Q*rho)/(3.14*D); //If Re<2100, the assumed laminar flow is correct
tau_rz = (2*delP*R)/(4*L);
end Ex3_1;
//The plot is not shown here
//The answer may slightly vary due to rounding off values
