model Ex3_11
//Parameter Section 
parameter Real l(unit = "inch") = 27 "Length of the cylinder in inches";
parameter Real kr(unit = "inch") = 0.495 "Outside radius of inner cylinder in inches";
parameter Real r(unit = "inch") = 1.1 "Inner radius of outer cylinder in inches";
parameter Real Mu(unit = "lbm/ft.hr") = 136.8 "Viscosity of the fluid in lbm/ft.s";
parameter Real Rho(unit = "lb/ft^3") = 80.3 "Density of the fluid in lb/ft^3";
parameter Real DelP(unit = "psi") = 5.39 "Pressure drop in psi";
//===========================================================================================
//Variable Section
Real L(unit = "m") "Length of the cylinder in metres";
Real K(unit = "nil") "Ratio of outside radius to inside radius";
Real R(unit = "m") "Inner cylinder of outer cylinder in metres";
Real mu(unit = "kg/m.s") "Viscosity of the fluid in kg/m.s";
Real delP(unit = "N/m^2") "Pressure drop in N//m^2";
Real Q(unit = "m^3/s") "Volumetric flow rate in m^3/s";
//===========================================================================================
//Equation Section
equation 
L = l*12*2.54*10^(-2); //1 inch = 2.54*10^(-2) m
K = kr/r;
R = r*2.54*10^(-2);
mu = (Mu*0.4536)/(0.3048*3600); //1 lb = 0.4536 kg and 1 ft = 0.3048 m; 1 hr = 3600 s
delP = (DelP*0.454*9.81)/(2.54*10^(-2))^2; //1 psi = 1 lb/in^2
Q = ((3.14*delP*R^4)*(1-K^4-((1-K^2)^2/log(1/K))))/(8*mu*L);
end Ex3_11;

