model Ex3_12
//Parameter Section
parameter Real d(unit = "m") = 1.27*10^(-2) "Diameter of the tube";
parameter Real Q(unit = "m^3/min") = 22.72*10^(-3) "Volumetric flowrate of oil";
parameter Real mu(unit = "cP") = 300 "Viscosity of the oil";
parameter Real rho(unit = "kg/m^3") = 960.6 "Density of oil";
//===================================================================================
//Variable Section
Real R(unit = "m") "Radius of the tube";
Real delP_per_L(unit = "N/m^3") "Pressure drop per meter of pipe length";
Real tau_rz(unit = "N/m^2") "Wall stress";
Real Vz_max(unit = "m/s") "Velocity at the centre of the tube";
Real Vz_avg(unit = "m/s") "Average velocity";
Real r(unit = "m") "Radial position at which velocityis equal to average velocity";
//===================================================================================
//Equation Section
equation
R = d/2;
delP_per_L = (8*(Q/60)*(mu*10^(-3)))/(3.14*R^4); //Hagen-Poiseuille equation
tau_rz = (delP_per_L*R)/2;
Vz_max = (delP_per_L*R^2)/(4*mu*10^(-3));
Vz_avg = Vz_max/2;
//At Vz = Vzavg
Vz_avg = Vz_max*(1-(r/R)^2);
end Ex3_12;
//The answer may slightly vary due to rounding off values
