model Ex3_2
//Parameter Section
parameter Real d(unit = "m") = 2.2*10^(-3) "Inside diameter of the tube";
parameter Real L(unit = "m") = 0.317 "Length of the tube";
parameter Real rho(unit = "kg/m^3") = 990 "Density of the liquid";
parameter Real mu(unit = "Pa.s") = 1.13*10^(-3) "Viscosity of fluid";
parameter Real v(unit = "m/s") = 0.275 "Velocity of the fluid";
//===========================================================================================================
//Variable Section
Real r(unit = "m") "Radius of the tube";
Real A(unit = "m^2") "Cross sectional Area";
Real Q(unit = "m^3/s") "Volumetric flow rate";
Real delP(unit = "N/m^2") "Pressure drop";
Real Re(unit = "nil") "Reynolds number";
//===========================================================================================================
//Equation Section
equation
r = d/2;
A = (3.14*d^2)/4;
Q = v*A;
delP = (8*mu*L*Q)/(3.14*r^4);//Hagen-Poiseuille equation (Laminar flow is assumed)
Re = (d*v*rho)/mu; //If Re<2100, the assumed laminar flow is correct
end Ex3_2;
//The answer provided in the textbook for Reynolds number is wrong
//The value of velocity has been wrongly substituted for the calculation of Reynolds number in the textbook
