model Ex3_6
//Parameter Section
parameter Real gamma(unit = "m^2/s") = 2*10^(-4) "Kinematic Viscosity of the oil";
parameter Real rho(unit = "kg/m^3") = 800 "Density of the oil";
parameter Real delta(unit = "m") = 2.5*10^(-3) "Film thickness";
parameter Real beta(unit = "deg") = 0 "Angle"; //beta = 0 since it is a vertical wall
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
//===================================================================================
//Variable Section 
Real mu(unit = "kg/m.s") "Dynamic Viscosity of the oil";
Real V_z(unit = "m/s") "Velocity";
Real T(unit = "kg/m.s") "Liquid loading";
Real Re(unit = "nil") "Reynolds number";
//===================================================================================
//Equation Section 
equation 
mu = gamma*rho;
V_z = (rho*g*delta^2*cos(beta))/(3*mu);
T = rho*delta*V_z;
Re = (4*T)/mu; //For Re<1000 to 2000, the flow is laminar
end Ex3_6;
