model Ex6_1
//Parameter Section
parameter Real D(unit = "m") = 3*10^(-2) "Diameter of the tube";
parameter Real Q(unit = "m^3/s") = 1.1*10^(-3) "Flow rate of N,N-Diethyl aniline";
parameter Real rho(unit = "kg/m^3") = 935 "Density of the liquid";
parameter Real mu(unit = "N.s/m^2") = 1.95*10^(-3) "Viscosity of the liquid";
parameter Real f(unit = "nil") = 0.0063 "Friction factor obtained from graph of Re vs f for smooth pipe";
//===========================================================================================================
//Variable Section
Real Re(unit = "nil") "Reynolds number";
Real delP_per_L(unit = "N/m^3") "Pressure gradient to sustain the flow";
//===========================================================================================================
//Equation Section
equation 
Re = (4*Q*rho)/(3.14*D*mu);
delP_per_L = (4/D)*(1/2)*rho*((Q*4)/(3.14*D^2))^2*f;
end Ex6_1;
