model Ex6_10
//Parameter Section
parameter Real D(unit = "m") = 3*10^(-2) "Diameter of the circular pipe";
parameter Real Q(unit = "m^3/s") = 1.4*10^(-3) "Volumetric flow rate of fluid";
parameter Real rho(unit = "kg/m^3") = 935 "Density of the fluid";
parameter Real f(unit = "nil") = 0.0063 "friction factor";
//============================================================================
//Variable Section
Real A(unit = "m^2") "Area of the pipe";
Real Vavg(unit = "m/s") "Average Velocity of the fluid";
Real delP_per_L(unit = "N/m^3") "Pressure drop per unit length";
//============================================================================
//Equation Section
equation 
A = (3.14*(D^2))/4;
Vavg = Q/A;
delP_per_L = (2*f*rho*Vavg^2)/D;
end Ex6_10;
//The answer slightly varies due to rounding off values
