model Ex6_14
//Parameter Section
parameter Real D(unit = "m") = 7.83*10^(-2) "Internal diameter of the pipe";
parameter Real L(unit = "m") = 28.95 "Length of the pipe";
parameter Real Q(unit = "lit/min") = 68.13 "Volumetric flow rate of water";
parameter Real mu(unit = "kg/m.s") = 1.002*10^(-3) "Viscosity of water";
parameter Real rho(unit = "kg/m^3") = 998.2 "Density of water";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
parameter Real hL_minus_h0(unit = "ft") = 50 "Distance between the two elbows";
parameter Real l(unit = "m") = (2*15*7.83*10^(-2)) "Pipe length offering resistance due to two 45 deg elbows";
//A standard radius of 45 deg elbow is roughly equivalent to the resistance offered by a pipe of length equal to 15 diameters";
//============================================================================================================
//Variable Section
Real A(unit = "m^2") "Cross sectional area of the pipe";
Real V(unit = "m/s") "Average velocity";
Real Re(unit = "nil") "Reynolds number";
Real f(unit = "nil") "Friction factor";
Real Le(unit = "m") "Equivalent length of the pipe";
Real delPf(unit = "N/m^2") "Pressure drop due to friction";
Real delP(unit = "N/m^2") "Pressure drop";
Real delP_psi(unit = "psi") "Pressure drop in psi";
Real percentage(unit = "%") "% of pressure drop to overcome friction"; 
//============================================================================================================
//Equation Section
equation
A = (3.14*D^2)/4;
V = ((Q*10^(-3))/60)/A; //1m^3 = 1000 L and 1 min = 60 sec
Re = (D*V*rho)/mu;
f = 0.0791/Re^0.25; //Since the flow is turbulent
Le = L+l;
delPf = (2*f*(V^2)*rho*Le)/D;
delP = (((hL_minus_h0*0.3048)/sqrt(2))*rho*g)+delPf; //1 ft = 0.3048 m
delP_psi = (delP/(1.01325*10^5))*14.69;
percentage = (delPf/delP)*100;
end Ex6_14;
//The answer provided in the book is wrong
//The value of ve locity has been wrongly substituted in the calculation part of hf
