model Ex6_15
//Parameter Section
parameter Real D(unit = "m") = 0.25 "Internal diameter of the pipe";
parameter Real L(unit = "m") = 1234 "Length of the pipe";
parameter Real Q(unit = "m^3/s") = 1.97 "Volumetric flow rate of water";
parameter Real mu(unit = "kg/m.s") = 10^(-3) "Viscosity of water";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of water";
parameter Real l1(unit = "m") = (4*32*0.25) "Pipe length offering resistance due to two 45 deg elbows";
parameter Real l2(unit = "m") = (2*15*0.25) "Pipe length offering resistance due to two 45 deg elbows";
//A standard radius of 90 deg elbow is roughly equivalent to the resistance offered by a pipe of length equal to 32 diameters and 45 deg elbow is equal to 15 diameters
parameter Real f(unit = "nil") = 0.00195 "Friction factor obtained from a graph of Re vs f";
//For smooth pipe
//============================================================================================================
//Variable Section
Real A(unit = "m^2") "Cross sectional area of the pipe";
Real V(unit = "m/s") "Average velocity";
Real Re(unit = "nil") "Reynolds number";
Real Le(unit = "m") "Equivalent length of the pipe";
Real delP(unit = "N/m^2") "Pressure drop";
Real delP_psi(unit = "psi") "Pressure drop in psi";
//============================================================================================================
//Equation Section
equation
A = (3.14*D^2)/4;
V = Q/A;
Re = (D*V*rho)/mu;
Le = L+l1+l2;
delP = (2*f*(V^2)*rho*Le)/D;
delP_psi = (delP/(1.01325*10^5))*14.69; //1 atm = 1.01325*10^5 N/m^2 and 1 atm = 14.69 psi
end Ex6_15;
