model Ex6_7
//Parameter Section
parameter Real rho_bulk(unit = "kg/m^3") = 962 "Bulk density";
parameter Real rho_solid(unit = "kg/m^3") = 1000 "Solid Density";
parameter Real V_T(unit = "m^3") = 1 "Total volume of the bed";//Assumed
parameter Real dp(unit = "m") = 0.02  "Diameter of the particle";
//========================================================================
//Variable Section
Real epsilon(unit = "nil") "Void fraction";
Real V_v(unit = "m^3") "Volume of void";
Real S_f(unit = "nil") "Solid fraction";
Real av(unit = "m^(-1)") "Specific surface of particle";
Real a(unit = "m^2") "Wetted area";
Real De(unit = "m") "Equivalent diameter";
//========================================================================
//Equation Section
equation 
S_f = rho_bulk/rho_solid;
epsilon = 1-S_f;
V_v = epsilon*V_T;
av = 6/dp;
a = av*(1-epsilon);
De = (4*epsilon)/a;
end Ex6_7;
