model Ex7_14
//Parameter Section
parameter Real D(unit = "m") = 10.16*10^(-2) "Internal diameter of the U-shaped pipe";
parameter Real Q(unit = "m^3/min") = 5 "Volumetric flow rate of water";
parameter Real rho(unit = "kg/m^3") = 998.4 "Density of water";
parameter Real mu(unit = "N.s/m^2") = 1*10^(-3) "Viscosity of water";
parameter Real P1(unit = "atm") = 1.43 "Entrance pressure";
parameter Real P2(unit = "atm") = 1.3 "Exit pressure";
//======================================================================================
//Variable Section
Real S(unit = "m^2") "Cross sectional area";
Real V(unit = "m/s") "Velocity of the fluid";
Real m(unit = "kg/s") "Mass flowrate";
Real Fx(unit = "N") "Horizontal force exerted by the water on the U-bend";
//======================================================================================
//Equation Section
equation 
S = (3.14*D^2)/4;
V = (Q/60)/S; //1 min = 60 s
m = (Q/60)*rho;
//The force of the fluid is
//m1V1+m2V2+P1S1+P2S2
Fx = (2*V*m)+(S*(P1+P2)*1.01325*10^5); //1 atm = 1.01325*10^5 N/m^2
end Ex7_14;
//The answer may vary due to rounding off values
