model Ex7_3
//Parameter Section
parameter Real V1(unit = "m/s") = 1.52 "Velocity of the liquid at the inlet";
parameter Real V2(unit = "m/s") = 9.14 "Velocity of the liquid at the outlet";
parameter Real H1(unit = "J/kg") = 76.97*10^3 "Enthalpy at 18.33 deg C"; // from steam tables
parameter Real H2(unit = "J/kg") = 2771.4*10^3 "Enthalpy at 148.9 deg C"; // from steam tables
parameter Real delz(unit = "m") = 15.2 "Height between inlet and outlet";
parameter Real g(unit = "m/s") = 9.8 "Acceleration due to gravity";
parameter Real alpha(unit = "nil") = 1 "Kinetic energy correction factor"; 
//==================================================================================================
//Variable Section
Real delH(unit = "J/kg") "Change in enthalpy";
Real Q(unit = "J/kg") "Heat to be added per kg mass of steam";
//==================================================================================================
//Equation Section
equation 
//Bernoulli's equation is
//(delz*g)+((V2^2-V1^2)/(2*alpha))+(eta*Wp)+delH-Q = 0
//Here, no external work. Therefore, Wp = 0
//alpha = 1 for turbulent flow
delH = H2-H1;
delH+(delz*g)+((V2^2-V1^2)/(2*alpha))-Q = 0;
end Ex7_3;
