model Ex7_4
//Parameter Section 
parameter Real Q(unit = "m^3/min") = 0.567 "Volumetric flow rate";
parameter Real rho(unit = "kg/m^3") = 968.5 "Density of the fluid";
parameter Real H1(unit = "J/kg") = 355.9*10^3 "Enthalpy at 85 deg C"; // From steam tables
parameter Real delz(unit = "m") = 20 "Distance between two tanks";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
parameter Real heat_lost(unit = "kW") = 1408 "Heat lost by the water";
parameter Real energy(unit = "kW") = 7.45 "Energy supplied by the motor";
//===================================================================================================
//Variable Section
Real m(unit = "kg/s") "mass flow rate";
Real q(unit = "J/kg") "Heat added to the fluid";
Real Ws(unit = "J/kg") "Work done on the fluid";
Real H2(unit = "J/kg") "Enthalpy at tank 2";
//===================================================================================================
//Equation Section
equation 
m = (Q*rho)/60; //1 min = 60 s
Ws = -((energy*10^3)/m); //The value is negative since work is "done on" the fluid 
q = -(heat_lost*10^3)/m; //The value is negative since it "gives up" heat
//Bernoulli's equation is
//(delz*g)+((V2^2-V1^2)/(2*alpha))+(eta*Wp)+delH-Q = 0
//Any kinetic energy change can be neglected since the initial and final velocities in the tank are essentially zero 
H2 = q-Ws+H1-(delz*g); //From steam table, the value of H2 obtained corresponds to a temperature of 48.41 C"
end Ex7_4;
