model Ex7_5
//Parameter Section
parameter Real Q_gallon_per_min(unit = "gal/min") = 69.1 "Volumetric flowrate of liquid solution";
parameter Real d2_in(unit = "in") = 2.067 "Diameter of pipe section 2 in inches";
parameter Real d3_in(unit = "in") = 3.068 "Diameter of pipe section 3 in inches";
parameter Real d4_in(unit = "in") = 2.067 "Diameter of pipe section 4 in inches";
parameter Real eta(unit = "nil") = 0.65 "Efficiency of the pump";
parameter Real rho(unit = "kg/m^3") = 1836.8 "Density of the liquid solution";
parameter Real delz(unit = "ft") = 50 "Distance between the discharge line end and the liquid level in feed tank";
parameter Real alpha(unit = "nil") = 1 "Kinetic energy correction factor";//For turbulent flow
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity"; 
parameter Real hf(unit = "J/kg") = 29.6 "Friction losses in pipe";
//============================================================================================================
//Variable Section
Real Q(unit = "m^3/s") "Volumetric flow rate in m^3/s";
Real d2(unit = "m") "Diameter of pipe section 2 in metres";
Real d3(unit = "m") "Diameter of pipe section 3 in metres";
Real d4(unit = "m") "Diameter of pipe section 4 in metres";
Real m(unit = "kg/s") "Mass flow rate"; 
Real V2(unit = "m/s") "Velocity of the fluid in pipe section 2"; 
Real V3(unit = "m/s") "Velocity of the fluid in pipe section 3";
Real V4(unit = "m/s") "Velocity of the fluid in pipe section 4";
Real Wp(unit = "J/kg") "Power required";
Real Wp_W(unit = "W") "Power required in Watts";
Real Wp_hp(unit = "hp") "Power required in hp";
Real delP(unit = "N/m^2") "Pressure developed";
//============================================================================================================
//Equation Section
equation
Q = (Q_gallon_per_min*3.78*10^(-3))/60; //1 gallon = 3.78 L //1 m^3 = 1000 L //1 min = 60 s
d2 = d2_in*0.0254; //1 inch = 0.0254 m
d3 = d3_in*0.0254;
d4 = d4_in*0.0254;
m = Q*rho;
V2 = (Q*4)/(3.14*d2^2);
//Bernoulli's equation is
//(delP/rho)+(delz*g)+((V2^2-V1^2)/(2*alpha))+hf-(eta*Wp) = 0
//P1 = P2 and V1 = 0; alpha = 1 for turbulent flow
(delz*0.3048*g)+(V2^2/(2*alpha))+hf-(eta*Wp) = 0; //1 ft = 0.3048 m
Wp_W = Wp*m;
Wp_hp = Wp_W/746; //1 hp = 746 W
V3 = (Q*4)/(3.14*d3^2);
V4 = (Q*4)/(3.14*d4^2);
////Bernoulli's equation is
//(delP/rho)+(delz*g)+((V4^2-V3^2)/(2*alpha))+hf-(eta*Wp) = 0
//delz = 0 since z3 = z4
(delP/rho)+((V4^2-V3^2)/(2*alpha))-(eta*Wp)=0;
end Ex7_5;
//The answer varies due to rounding off values
