model Ex8_2
//Parameter Section
parameter Real sigma(unit = "Angstrom") = 2.789 "Lennard-Jones constant in Angstrom";
parameter Real omega_k(unit = "K") = 0.821 "Collision Integral";
parameter Real T(unit = "K") = 373.2 "Temperature in kelvin";
parameter Real M(unit = "g/gmole") = 20.183 "Molecular weight of neon";
//===============================================================================
//Variable Section
Real k(unit = "cal/cm.s.K") "Thermal conductivity of neon in cal/cm.s.K";
Real K(unit = "W/m.K") "Thermal conductivity of neon in W/m.K";
//===============================================================================
//Equation Section
equation
k = (1.9891*10^(-4)*sqrt(T/M))/(sigma^2*omega_k); //Chapman-Enskog equation
K = (k*4.184)/10^(-2); //1 cal = 4.184 J
end Ex8_2;
