model Ex8_5
//Parameter Section
parameter Real Cp_CH2O(unit = "cal/gmole.K") = 7.15 "Specific heat of formaldehyde in cal/gmole.K";
parameter Real Cp_CH4(unit = "val/gmole.K") = 8.55 "Specific heat of methane in cal/gmole.K";
parameter Real M_CH2O(unit = "g/gmole") = 30 "Molecular weight of formaldehyde";
parameter Real M_CH4(unit = "g/gmole") = 16 "Molecular weight of methane";
parameter Real sigma_CH2O(unit = "Angstrom") = 3.470 "Lennard-Jones constant in Angstrom";
parameter Real sigma_CH4(unit = "Angstrom") = 3.822 "Lennard-Jones constant in Angstrom";
parameter Real omega_CH2O(unit = "") = 1.081 "Collision integral";
parameter Real omega_CH4(unit = "") = 1.156 "Collision integral";
parameter Real T(unit = "K") = 300 "Temperature in K";
parameter Real R(unit = "cal/gmole.K") = 1.987 "Universal gas constant in cal/gmole.K";
//====================================================================================
//Variable Section
Real mu_CH2O(unit = "g/cm.s") "Coefficient of Viscosity";
Real mu_CH4(unit = "g/cm.s") "Coefficient of Viscosity";
Real k_CH2O(unit = "cal/cm.s.K") "Thermal conductivity";
Real k_CH4(unit = "cal/cm.s.K") "Thermal conductivity";
//====================================================================================
//Equation Section
equation
mu_CH2O = (2.6693*10^(-5)*sqrt(M_CH2O*T))/(sigma_CH2O^2*omega_CH2O);
mu_CH4 = (2.6693*10^(-5)*sqrt(M_CH4*T))/(sigma_CH4^2*omega_CH4);
k_CH2O = (Cp_CH2O+((5*R)/(4*M_CH2O)))*mu_CH2O;
k_CH4 = (Cp_CH4+((5*R)/(4*M_CH4)))*mu_CH4;
//Eucken equation
end Ex8_5;
//The answer for k_CH2O slightly varies due to rounding off values 
//The answer provided for k_CH4 in the textbook is wrong
