model Ex9_1
//Parameter Section
parameter Real delX(unit = "m") = 0.0254 "Thickness of the fibre insulating board";
parameter Real k(unit = "W/m.K") = 0.048 "Thermal conductivity of the fibre insulating board";
parameter Real T1(unit = "K") = 352.7 "Inside Temperature";
parameter Real T2(unit = "K") = 297.1 "Outside Temperature";
//==========================================================================
//Variable section
Real delT(unit = "C") "Temperature driving force";
Real q(unit = "W/m^2")"Heat transfer per unit area (Q/A)";
//==========================================================================
//Equation section
equation
delT = (T1-T2);
q = (k*delT)/delX;//Fourier's law of heat conduction
end Ex9_1;
