model Ex9_17
//Parameter Section
parameter Real Ta(unit = "F") = 350 "Temperature of the air";
parameter Real Tw(unit = "F") = 500 "Temperature of the wall";
parameter Real k(unit = "Btu/hr.ft.F") = 60 "Thermal conductivity of the fin";
parameter Real h(unit = "Btu/hr.ft^2.F") = 120 "Heat transfer coefficient";
parameter Real L(unit = "ft") = 0.2 "Length of the fin";
parameter Real W(unit = "ft") = 1 "Width of the fin";
parameter Real B_in(unit = "in") = 0.16 "Thickness of the fin";
//=============================================================================
//Variable Section 
Real B(unit = "ft") "Thickness of the fin in ft";
Real Eta(unit = "nil") "Efficiency of the fin";
Real Q(unit = "Btu/hr") "Heat loss from the ractangular fin";
//=============================================================================
//Equation Section
equation
B = 0.16/(2*12); //i ft = 12 inch
Eta = (tanh(sqrt((h*L^2)/(k*B))))/sqrt((h*L^2)/(k*B));
Q = Eta*h*2*W*L*(Tw-Ta);
end Ex9_17;
//The answer may slightly vary due to rounding off values
