model Ex9_18
//Parameter Section
parameter Real D(unit = "m") = 2*10^(-3) "Diameter of the wire";
parameter Real k(unit = "W/m.K") = 20 "Thermal conductivity of the wire";
parameter Real L(unit = "m") = 1 "Length of the wire";
parameter Real R(unit = "ohm") = 0.1/0.3048 "Resistance offered by the wire";
parameter Real I(unit = "A") = 100 "Electric current";
//=================================================================================
//Variable Section
Real r(unit = "m") "Radius of the wire";
Real Q(unit = "W") "Heat generated";
Real V(unit = "m^3") "Volume of the wire";
Real Se(unit = "W/m^3") "Heat generated per unit volume";
Real delT(unit = "C") "Temperature difference between the centre and surface of the wire";
//==================================================================================
//Equation Section
equation
r = D/2;
Q = I^2*R;
V = 3.14*r^2*L;
Se = Q/V;
delT = (Se*r^2)/(4*k);   
end Ex9_18;
