model Ex9_6
//Parameter Section 
//Bulb is considered as spherical body
parameter Real K(unit = "W/m.K") = 0.84 "Thermal conductivity";
parameter Real Q(unit = "W") = 60 "Heat loss from the bulb";
parameter Real r(unit = "m") = 0.3 "Distance from the reference";//Reference is 0 m
//======================================================================================
//Variable Section
Real T(unit = "C") "Temperature at a distance of 0.3 m away from the reference";
//======================================================================================
//Equation Section
equation
T = (Q/(4*3.14*K))*(1/r);
end Ex9_6;
