model Ex11_1
//Parameter Section
parameter Real K(unit = "W/m.K") = 0.028 "Thermal conductivity of the copper";
parameter Real rho(unit = "kg/m^3") = 1.097 "Density of copper";
parameter Real mu(unit = "Pa.s") = 1.95*10^(-5) "Viscosity of copper";
parameter Real L(unit = "m") = 0.051 "Length of thin fin of copper";
parameter Real V(unit = "m/s") = 12.2 "Velocity of the cooling air";
parameter Real Pr(unit = "nil") = 0.704 "Prandtl number";
//================================================================================
//Variable Section
Real Re(unit = "nil") "Reynolds number";
Real Nu_laminar(unit = "nil") "Nusselt number for laminar flow conditions";
Real Nu_turbulent(unit = "nil") "Nusselt number for turbulent flow conditions";
Real h_laminar(unit = "W/m^2.K") "Heat transfer coefficient for laminar flow";
Real h_turbulent(unit = "W/m^2.K") "Heat transfer coefficient for turbulent flow";
//Equation Section 
equation 
Re = (L*V*rho)/mu;
Nu_laminar = 0.664*Re^0.5*Pr^0.333;
h_laminar = (Nu_laminar*K)/L;
Nu_turbulent = 0.0366*Re^0.8*Pr^(1/3);
h_turbulent = (Nu_turbulent*K)/L;
end Ex11_1;
