model Ex12_4
//Parameter Section
parameter Real A(unit = "m^2") = 3*3 "Area of oxidised iron plates"; // A1 = A2
parameter Real sigma(unit = "W/m^2.K^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
parameter Real T1(unit = "C") = 100 "Temperature of one plate";
parameter Real T2(unit = "C") = 40 "Temperature of the other plate";
parameter Real epsilon(unit = "nil") = 0.736 "Emissivities of both the plates are same";
// epsilon 1 = epsilon 2
//====================================================================================
//Variable Section 
Real Q12(unit = "W") "Rate of heat transfer";
//====================================================================================
//Equation Section
equation 
Q12 = (sigma*A*((T1+273)^4-(T2+273)^4))/((1/epsilon)+(1/epsilon)-1);
end Ex12_4;
// The answer may slightly vary due to rounding off values
