model Ex12_9
//Parameter Section 
parameter Real D(unit = "inch") = 6 "Diameter of the thin copper sphere";
parameter Real e(unit = "nil") = 0.57 "Emissivity of copper";
parameter Real e_hole(unit = "nil") = 0.99 "Absorptivity of the hole";
//============================================================================
//Variable Section
Real r_sphere(unit = "inch") "Radius of the sphere";
Real f(unit = "nil") "Fraction of the total internal cavity area that is cut away by the hole";
Real r_hole(unit = "inch") "Radius of the hole";
//============================================================================
//Equation Section
equation
r_sphere = D/2;
f = ((1-e_hole)*e)/(e_hole*(1-e));
f = (1/4)*(r_hole/r_sphere)^2;
end Ex12_9;
