model Ex14_11
//Parameter Section
//A = He B = Air
parameter Real D_AB(unit = "m^2/s") = 1.16*10^(-15) "Diffusivity of helium in pyrex glass ";
parameter Real p_A1(unit = "N/m^") = 100*10^3 "Partial pressure of Helium at point 1";
parameter Real p_A2(unit = "N/m^2") = 0 "Partial pressure of Helium at point 2";
parameter Real P_T(unit = "N/m^2") = 100*10^3 "Total Pressure of the system";
parameter Real delz(unit = "m") = 2*10^(-3) "Distance between two points";
parameter Real T(unit = "K") = 293 "Temperature of the system";
parameter Real R(unit = "J/Kmol.K") = 8314 "Universal gas constant";
//===========================================================================================
//Variable Section
Real p_B1(unit = "N/m^2") "Partial pressure of air at point 1";
Real p_B2(unit = "N/m^2") "Partial pressure of air at point 2";
Real P_B_lm(unit = "N/m^2") "Logarithmic mean partial pressure";
Real NA(unit = "Kmole/m^2.s") "Flux of diffusion of helium into air";
//===========================================================================================
//Equation Section
equation
p_B1 = P_T - p_A1;
p_B2 = P_T - p_A2;
P_B_lm = (p_B1+p_B2)/2; // Since p_B1 is so close to p_B2, linear mean is used
NA = (D_AB*P_T*(p_A1-p_A2))/(R*T*delz*P_B_lm);
end Ex14_11;
