model Ex14_9
//Parameter Section
//A = Water B = Air
parameter Real D_AB(unit = "m^2/s") = 0.25*10^(-4) "Diffusivity of water vapour in air";
parameter Real Ps_A1(unit = "mmHg") = 17.54 "Vapour pressure of water vapour at point 1";
parameter Real p_A2(unit = "N/m^2") = 0 "Partial pressure of water vapour at point 2"; //since it is pure air
parameter Real P_T_mmHg(unit = "mmHg") = 760 "Atmospheric Pressure in mmHg";
parameter Real P_T(unit = "N/m^2") = 1.01325*10^5 "Total Pressure of the system";
parameter Real delz(unit = "m") = 0.1524 "Distance between two points";
parameter Real T(unit = "K") = 293 "Temperature of the system";
parameter Real R(unit = "J/Kmol.K") = 8314 "Universal gas constant";
//===========================================================================================
//Variable Section
Real p_A1(unit = "N/m^2") "Partial pressure of water vapourat point 1";
Real p_B1(unit = "N/m^2") "Partial pressure of air at point 1";
Real p_B2(unit = "N/m^2") "Partial pressure of air at point 2";
Real P_B_lm(unit = "N/m^2") "Logarithmic mean partial pressure";
Real NA(unit = "Kmole/m^2.s") "Flux of diffusion of water vapour through air in kmole/m^2.s";
//===========================================================================================
//Equation Section
equation
p_A1 = (Ps_A1/P_T_mmHg)*P_T;
p_B1 = P_T - p_A1;
p_B2 = P_T - p_A2;
P_B_lm = (p_B2-p_B1)/log(p_B2/p_B1);
NA = (D_AB*P_T*(p_A1-p_A2))/(R*T*delz*P_B_lm);
end Ex14_9;
