model Ex2_6
//Parameter section
parameter Real mu(unit = "g/cm.s") = 0.0177 "Viscosity of ethyl alcohol";
parameter Real delVz(unit = "cm/s") = 10 "Difference in velocity";
parameter Real dely(unit = "cm") = 0.5 "Distance between the plates";
//==============================================================================
//Variable Section
Real tau_yz(unit = "dyn/cm^2") "Shear stress";
Real rate(unit = "sec^(-1)") "Shear rate";
//==============================================================================
//Equation Section
equation
tau_yz = (mu*delVz)/dely;
rate = delVz/dely;
end Ex2_6;
