model Ex3_13
//Parameter Section
parameter Real KR(unit = "m") = 0.0254 "Outer radius of Inner cylinder";
parameter Real R(unit = "m") = 0.02545 "Inner radius of outer cylinder";
parameter Real Mu(unit = "cP") = 200 "Viscosity of the oil in cP";
parameter Real L(unit = "m") = 5.08*10^(-2) "Length of the bearing surface on the shaft";
parameter Real omega(unit = "rev/min") = 200 "Speed of the shaft in rev/min";
//==========================================================================
//Variable Section
Real K(unit = "nil") "Ratio of outside radius to inside radius";
Real mu(unit = "kg/m.s") "Viscosity of the oil in kg/m.s";
Real Omega(unit = "rad/sec") "Speed of the shaft in rad/sec";
Real tau(unit = "N.m") "Torque in N.m";
Real P_W(unit = "W") "Power in Watts";
Real P(unit = "hp") "Power in HorsePower";
//==========================================================================
//Equation Section
equation
K = KR/R;
mu = Mu*10^(-3);
Omega = (omega*3.14*2)/60; //(2*pi)/60 is used to convert from rev/min to rad/sec
tau = (4*3.14*mu*L*Omega*R^2*K^2)/(1-K^2);
P_W = tau*Omega;
P = P_W/745.69; //1 hp = 745.69 W
end Ex3_13;
