model Ex3_3
//Parameter Section
parameter Real mu(unit = "N.s/m^2") = 10^(-3) "Viscosity of the pure water";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of pure water";
parameter Real T(unit = "kg/m.s") = 0.124 "Liquid loading";
parameter Real beta(unit = "nil") = 0 "Angle"; //since vertical wetted column
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
//===========================================================================
//Variable Section
Real delta(unit = "m") "Film thickness";
Real Vavg(unit = "m/s") "Average velocity"; 
//===========================================================================
//Equation Section
equation
T = rho*delta*((rho*g*cos(beta)*delta^2)/(3*mu)); 
// T = rho*delta*Vavg and Vavg = (rho*g*cos(beta)*delta^2)/(3*mu);
Vavg = (rho*g*cos(beta)*delta^2)/(3*mu);
end Ex3_3;
