model Ex3_4
//Parameter Section
parameter Real L(unit = "m") = 50.02*10^(-2) "Length of capillary";
parameter Real gamma(unit = "m^2/s") = 4.03*10^(-5) "Kinematic viscosity";
parameter Real rho(unit = "kg/m^3") = 0.9552*10^3 "Density of fluid";
parameter Real delP(unit = "N/m^2") = 4.829*10^5 "Pressure drop across the tube";
parameter Real m(unit = "kg/s") = 2.997*10^(-3) "mass flow rate through the tube";
//==============================================================================
//Variable Section
Real mu(unit = "kg/m.s") "Dynamic viscosity of the fluid";
Real Q(unit = "m^3/s") "Volumetric flow rate of the fluid";
Real R(unit = "m") "Radius of the capillary in meter";
Real R_mm(unit = "mm") "Radius of the capillary in millimeter";
Real D(unit = "m") "Diameter of the capillary";
Real Re(unit = "nil") "Reynolds number";
//==============================================================================
//Equation Section
equation
mu = gamma*rho;
Q = m/rho;
R = ((Q*8*mu*L)/(3.14*delP))^(1/4); //Hagen-Poiseuille equation //Laminar flow is assumed
R_mm = R*10^(3);
D = 2*R;
Re = (4*Q*rho)/(3.14*D*mu); //If Re<2100, assumed laminar flow is correct
end Ex3_4;
