model Ex3_9
//Parameter Section
parameter Real d(unit = "mm") = 2.222 "Diameter of the capillary";
parameter Real L(unit = "m") = 0.1585 "Length of the capillary";
parameter Real Q(unit = "m^3/s") = 5.33*10^(-7) "Volumetric flow rate of the liquid";
parameter Real delP(unit = "mm of H2O") = 119 "Pressure drop in mm of H2O";
//=========================================================================
//Variable Section 
Real R(unit = "m") "Radius of the capillary";
Real DelP(unit = "N/m^2") "Pressure drop in N/m^2";
Real mu(unit = "kg/m.s") "Viscosity of the fluid";
Real mu_Poise(unit = "Poise") "Viscosity of the liquid in Poise";
//=========================================================================
//Equation Section 
equation 
R = (d/2)*10^(-3);
DelP = ((delP*10^(-3))/10.33)*(1.01325*10^5); // 1 atm = 10.33 m of H2O
mu = (3.14*DelP*R^4)/(8*Q*L); //Hagen-Poiseuille equation
mu_Poise = (mu*1000)/100; // Converted from kg/m.s to g/cm.s(or Poise)
end Ex3_9;
