model Ex6_16
//Parameter Section
parameter Real ms(unit = "kg") = 0.05*10^(-3) "Mass of the sphere";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
parameter Real Dp(unit = "m") = 5*10^(-3) "Diameter of the particle";
parameter Real rhof(unit = "kg/m^3") = 900 "Density of the liquid";
parameter Real Vinf(unit = "m/s") = 5*10^(-3) "Terminal velocity";
//========================================================================
//Variable Section
Real Fg(unit = "N") "Force of gravity on sphere";
Real FB(unit = "N") "Buoyancy force";
Real FD_up(unit = "N") "Net upward drag force";
Real FD_down(unit = "N") "Net downward drag force";
Real f(unit = "nil") "Drag coefficient";
Real Re(unit = "nil") "Reynolds number";
Real mu(unit = "cP") "Viscosity";
//========================================================================
//Equation Section
equation 
Fg = ms*g;
FB = (3.14*Dp^3*rhof*g)/6;
FD_up = Fg-FB;
FD_down = -(FD_up);
f = FD_down/((3.14*Dp^2*rhof*Vinf^2)/(4*2));
Re = 24/f;
mu = (Dp*Vinf*rhof*10^3)/Re; //1 cP = 10^(-3) N.s/m^2
end Ex6_16;
