model Ex6_4
//Parameter Section
parameter Real Dp(unit = "m") = 12.7*10^(-3) "Diameter of the particle";
parameter Real epsilon(unit = "nil") = 0.38 "Porosity";
parameter Real D(unit = "m") = 0.61 "Diameter of the bed";
parameter Real delL(unit = "m") = 2.44 "Height of the bed";
parameter Real mu(unit = "N.s/m^2") = 1.9*10^(-5) "Viscosity of the air";
parameter Real T(unit = "K") = 312 "Temperature of the bed";
parameter Real P1(unit = "N/m^2") = 1.1*1.01325*10^5 "Pressure at the inlet of the bed";
parameter Real m(unit = "kg/s") = 0.358 "Mass flow rate of the air";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
parameter Real Mavg(unit = "g/gmole") = 28.84 "Average molecular weight of air";
parameter Real delP_assume(unit = "N/m^2") = 0.05*10^5 "Assumed value of pressure drop";
//===========================================================================================
//Variable Section
Real A(unit = "m^2") "Area of bed";
Real G(unit = "kg/m^2.s") "Mass velocity of air";
Real Re(unit = "nil") "Reynolds number";
Real P2(unit = "N/m^2") "Pressure at the exit of the bed";
Real Pavg(unit = "N/m^2") "Average Pressure";
Real rho_avg(unit = "kg/m^3") "Average density";
Real delP(unit = "N/m^2") "True value of Pressure drop";
//===========================================================================================
//Equation Section
equation
A = (3.14*D^2)/4;
G = m/A;
Re = (Dp*G)/((1-epsilon)*mu);
delP_assume = P1-P2;
Pavg = (P1+P2)/2;
rho_avg = (Pavg*Mavg)/(R*T);
((delP*Dp*epsilon^3*rho_avg)/(G^2*delL*(1-epsilon))) = (150/Re)+1.75; //Ergun equation
//If the value of delP calculated is near to assumed value, then our assumption is correct
//Here the calculated delP is nearly equal to to the assumed value.Hence our assumption is correct
end Ex6_4;
