model Ex7_12
//Parameter Section
parameter Real D(unit = "m") = 0.1023 "Internal diameter of the pipe";
parameter Real Q(unit = "m^3/s") = 5*10^(-3) "Volumetric flow rate of water";
parameter Real mu(unit = "kg/m.s") = 1.005*10^(-3) "Viscosity of water";
parameter Real rho(unit = "kg/m^3") = 998.2 "Density of water";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
parameter Real eta(unit = "nil") = 0.65 "Efficiency of the pump";
parameter Real L(unit = "m") = 15+5+50+100 "Length of the pipe";
parameter Real delz(unit = "m") = 15 "Height difference between two tanks";
parameter Real e_vi(unit = "m") = 0.45+(2*0.5)+1 "Friction loss factor associated with viscous dissipation";
//Energy losses due to sudden contraction,two 90 deg elbows and sudden expansion
//============================================================================================================
//Variable Section
Real A(unit = "m^2") "Cross section area of the pipe";
Real V(unit = "m/s") "Average velocity";
Real Re(unit = "nil") "Reynolds number";
Real f(unit = "nil") "Friction factor";
Real hfg(unit = "J/kg") "Friction loss in pipe";
Real m(unit = "kg/s") "Mass flow rate";
Real Wp(unit = "J/kg") "Power required";
Real Wp_W(unit = "W") "Power required in Watts";
//============================================================================================================
//Equation Section
equation
A = (3.14*D^2)/4;
V = Q/A;
Re = (D*V*rho)/mu;
f = 0.0791/Re^0.25; //For turbulent flow
hfg = (2*f*L*V^2)/D;
//Bernoulli's equation is
//(delP/rho)+(delz*g)+((V2^2-V1^2)/(2*alpha))-hf-((1/2)*V^2*ev) = 0
//P1 = P2 = 1 atm; V1 = V2
(delz*g)-(eta*Wp)-hfg-((1/2)*V^2*e_vi) = 0; //Work is done by the fluid
m = Q*rho;
Wp_W = Wp*m;
end Ex7_12;
