model Ex7_8
//Parameter Section
parameter Real rho(unit = "kg/m^3") = 998 "Density of water";
parameter Real delz(unit = "m") = 3.05 "Distance between the entance and exit section of the pipe";
parameter Real P1(unit = "N/m^2") = 68.9*10^3 "Entance pressure of the fluid";
parameter Real P2(unit = "N/m^2") = 137.8*10^3 "Exit pressure";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
parameter Real eta_Wp(unit = "J/kg") = 155.4 "Work done by the pump";
//==================================================================================================
//Variable Section
Real hf(unit = "J/kg") "Friction loss in the pipe system";
//==================================================================================================
//Equation Section
equation 
//Bernoulli's equation is
//(delP/rho)+(delz*g)+((V2^2-V1^2)/(2*alpha))-(eta*Wp)-hf=0
hf = ((P1-P2)/rho)-(delz*g)+eta_Wp;
end Ex7_8;
