model Ex8_3
//Parameter Section
parameter Real A(unit = "m^2") = 929*10^(-4) "Area of the plastic panel";
parameter Real Y(unit = "m") = 0.64*10^(-2) "Thickness of the plate";
parameter Real Q(unit = "W") = 3 "Heat transfer rate";
parameter Real T0(unit = "C") = 24 "Temperature at one surface";
parameter Real T1(unit = "C") = 26 "Temperature at another surface";
//==========================================================================
//Variable Section
Real Tavg(unit = "C") "Average Temperature in C";
Real delT(unit = "C") "Temperature difference in C";
Real k(unit = "W/m.K") "Thermal conductivity of the plastic";
//==========================================================================
//Equation Section 
equation
Tavg = (T0+T1)/2;
delT = (T1-T0);
k = (Q*Y)/(A*delT);
end Ex8_3;
