model Ex8_4
//Parameter Section
parameter Real rho(unit = "g/cm^3") = 1.595 "Density of liquid CCl4";
parameter Real comp(unit = "atm^(-1)") = 90.7*10^(-6) "Compressibility";
parameter Real M(unit = "g/gmole") = 153.84 "Molecular weight of CCl4";
parameter Real N(unit = "molecules/gmole") = 6.023*10^23 "Avagadro number";
parameter Real K_constant(unit = "erg/molecule.K") = 1.38*10^(-16) "Boltzmann constant";
//=======================================================================================================
//Variable Section
Real dP_by_drho_T(unit = "cm^2/s^2") "Quantity obtainable from isotheRmal compressibility measurements";
Real V(unit = "cm^3/gmole") "Molar Volume";
Real k(unit = "erg/cm.s.K") "Thermal conductivity";
Real K(unit = "W/m.K") "Thermal conductivity in W/m.K";
//=======================================================================================================
//Equation Section
equation 
//Cp/Cv is assumed to be 1
//Vs = sqrt((Cp/Cv)*(dP/drho)T) Vs-velocity of low frequency sound
dP_by_drho_T = (10^3*1.01325*10^5)/(rho*comp*10^2); //1 atm = 1.01325*10^5 N/m^2
V = M/rho;
k = 2.8*(N/V)^(2/3)*K_constant*sqrt(dP_by_drho_T); //Bridgman's equation
K = k*2.39*10^(-8)*4.184*10^2;
//1 erg = 2.39*10^(-8) cal
//1 cal = 4.184 J
//1 cm = 10^(-2) m
end Ex8_4;
//The answer slightly varies due to rounding off values
