model Ex9_14
//Parameter Section
parameter Real Ts(unit = "K") = 404 "Temperature of the saturated steam";
parameter Real Ta(unit = "K") = 294 "Temperature of the surrounding air";
parameter Real hi(unit = "W/m^2.K") = 5680 "Convective coefficient on the inner pipe surface";
parameter Real ho(unit = "W/m^2.K") = 22.7 "Convective coefficient on the outer pipe surface";
parameter Real di(unit = "m") = 0.0209 "Inside diameter of the steel pipe";
parameter Real do(unit = "m") = 0.0267 "Outer diameter of the steel pipe";
parameter Real L(unit = "m") = 1 "Length of the pipe";
parameter Real x_ins(unit = "m") = 0.038 "Thickness of the insulation";
parameter Real K1(unit = "W/m.K") = 42.9 "Thermal conductivity of steel";
parameter Real K2(unit = "W/m.K") = 0.0675 "Thermal conductivity of insulation";
//==============================================================================================
//Variable Section
Real ri(unit = "m") "Inner radius of the steel pipe";
Real ro(unit = "m") "Outer radius of the steel pipe";
Real r_ins(unit = "m") "Radius of the insulation";
Real R1(unit = "K/W") "Thermal resistance offered by convection tube";
Real R2(unit = "K/W") "Thermal resistance for the convection outside";
Real R3(unit = "K/W") "Thermal resistance for conduction";
Real q(unit = "W/m") "Heat loss per meter of bare pipe";
Real R4(unit = "K/W") "Thermal resistance by the insulation for convection";
Real R5(unit = "K/W") "Thermal resistance by the insulation for conduction";
Real q_ins(unit = "W/m") "Heat loss per meter of the insulated pipe";
//==============================================================================================
//Equation Section
equation
ri = di/2;
ro = do/2;
R1 = 1/(hi*2*3.14*ri*L);
R2 = 1/(ho*2*3.14*ro*L);
R3 = log(ro/ri)/(2*3.14*K1*L);
q = (Ts-Ta)/(R1+R2+R3);
r_ins = ro+x_ins;
R4 = log(r_ins/ro)/(2*3.14*K2*L);
R5 = 1/(ho*2*3.14*r_ins*L);
q_ins = (Ts-Ta)/(R4+R5);
end Ex9_14;
