model Ex9_19
//Parameter Section
parameter Real K(unit = "W/m^2.k") = 222 "Thermal conductivity of aluminium fin";
parameter Real r1(unit = "m") = 0.04 "Outer radius of the copper tube";
parameter Real L(unit = "m") = 0.04 "Length of the fin";
parameter Real twoB(unit = "m") = 0.002 "Thickness of the fin";
parameter Real T0(unit = "K") = 523.2 "Temperature of the tube base";
parameter Real Tinf(unit = "K") = 343.2 "Temperature of the surrounding air";
parameter Real h(unit = "W/m^2.K") = 30 "Heat transfer coefficient";
parameter Real etaf(unit = "nil") = 0.89; //Obtained from the graph of etaf versus Lc
//======================================================================================
//Variable Section
Real Lc(unit = "m") "Corrected length";
Real factor(unit = "nil"); //Factor = Lc(h/(k.2B))^(1/2)
Real Af(unit = "m^2") "Outside surface area of the fin";
Real qf(unit = "W") "Rate of Heat transfer from the fin";
//======================================================================================
//Equation Section 
equation
Lc = L+(twoB/2);
factor = Lc*(h/(twoB*K))^(1/2);
Af = (2*3.14*((Lc+r1)^2-r1^2)); //for circular fin
qf = etaf*h*Af*(T0-Tinf);
end Ex9_19; 
