model Ex9_2
//Parameter Section
parameter Real K(unit = "W/m.K") = 0.151 "Thermal conductivity of hard rubber";
parameter Real r1(unit = "m") = 5*10^(-3) "Inside radius of the cylindrical tubing";
parameter Real r2(unit = "m") = 0.02 "Outside radius of the tubing";
parameter Real T1(unit = "K") = 274.9 "Inside wall temperature";
parameter Real T2(unit = "K") = 297.1 "Outside surface temperature";
parameter Real Q(unit = "W") = 14.65 "Heat removed from the bath by cooling coil";
//========================================================================================
//Variable Section
Real L(unit = "m") "Length of the tubing";
//========================================================================================
//Equation Section 
equation
Q = (K*2*3.14*L*(T1-T2))/(log(r1/r2)); //Fourier's law of heat conduction 
end Ex9_2;
