model Ex9_4
//Parameter Section
//A-Stainless Steel B-Insulation
parameter Real d1(unit = "m") = 0.0254 "Inside Diameter of the stainless steel tube";
parameter Real d2(unit = "m") = 0.0508 "Outer Diameter of the stainless steel tube";
parameter Real d3(unit = "m") = 0.1016 "Diameter of the insulation";
parameter Real L(unit = "m") = 0.305 "Length of the tube";
parameter Real KA(unit = "W/m.K") = 21.93 "Thermal conductivity of stainless steel";
parameter Real KB(unit = "W/m.K") = 0.2423 "Thermal conductivity of insulation";
parameter Real T1(unit = "K") = 811 "Inside wall Temperature of the tube";
parameter Real T3(unit = "K") = 310.8 "Outside surface temperature of the insulation";
//========================================================================================
//Variable Section
Real r1(unit = "m") "Inside Radius of the stainless steel layer";
Real r2(unit = "m") "Outside Radius of the stainless steel layer";
Real r3(unit = "m") "Radius of the insulation layer";
Real A1(unit = "m^2") "Inner area of the stainless steel tube";
Real A2(unit = "m^2") "Outer area of the stainless steel tube";
Real A3(unit = "m^2") "Area of the insulation material";
Real AA_lm(unit = "m^2") "Logarithmic mean area for stainless steel mterial";
Real AB_lm(unit = "m^2") "Logarithmic mean area for insulation material";
Real RA(unit = "K/W") "Resistance for stainless steel material";
Real RB(unit = "K/W") "Resistance for insulation material";
Real Q(unit = "W") "Heat transfer rate";
Real T2(unit = "K") "Temperature at the inteface between stainless steel and insulation";
//=========================================================================================
//Equation Section
equation
r1 = d1/2;
r2 = d2/2;
r3 = d3/2;
A1 = 2*3.14*r1*L;
A2 = 2*3.14*r2*L;
A3 = 2*3.14*r3*L;
AA_lm = (A2-A1)/log(A2/A1);
AB_lm = (A3-A2)/log(A3/A2);
RA = (r2-r1)/(KA*AA_lm);
RB = (r3-r2)/(KB*AB_lm);
Q = (T1-T3)/(RA+RB);
T2 = T1-(Q*RA);
end Ex9_4;
