model Ex9_5
//Parameter Section
parameter Real di(unit = "inch") = 0.824 "Inside diameter of the steel pipe";
parameter Real d1(unit = "inch") = 1.05 "Outside diameter of the steel pipe";
parameter Real do(unit = "inch") = 4.05 "Diameter of the lagging";
parameter Real hi(unit = "Btu/hr.ft^2.degF") = 1000 "Convective heat transfer coefficient for steam flowing on the inside surface of the pipe";
parameter Real ho(unit = "Btu/hr.ft^2.degF") = 2 "Convective heat transfer coefficient on the outside of the lagging";
parameter Real K_metal(unit = "Btu/hr.ft.degF") = 26 "Mean thermal conductivity of steel";
parameter Real K_lagging(unit = "Btu/hr.ft.degF") = 0.037 "Thermal conducitivity of insulation";
parameter Real L(unit = "ft") = 1 "Heat transfer area";
parameter Real Ti(unit = "degF") = 267 "Temperature of the saturated steam flowing inside the steel pipe";
parameter Real To(unit = "degF") = 80 "Temperature of the surrounding air";
//=============================================================================================
//Variable Section
Real ri(unit = "ft") "Inside radius of the steel pipe";
Real r1(unit = "ft") "Outside radius of the steel pipe";
Real ro(unit = "ft") "Radius of the lagging";
Real Ai(unit = "ft^2") "Inner surface area of the steel pipe";
Real A1(unit = "ft^2") "Outer surface area of the steel pipe";
Real Ao(unit = "ft^2") "Surface area of the lagging";
Real AA_lm(unit = "ft^2") "Log mean area of the steel surface";
Real AB_lm(unit = "ft^2") "Log mean area of the lagging";
Real Ri(unit = "hr.degF/Btu") "Resistance offered by the ";
Real RA(unit = "hr.degF/Btu") "Resistance offered by the steel";
Real RB(unit = "hr.degF/Btu") "Resistance offered by the lagging";
Real Ro(unit = "hr.degF/Btu") "Resistance offered by the ";
Real Q(unit = "Btu/hr") "Rate of heat transfer";
Real sigmaR(unit = "hr.degF/Btu") "Sum of the resistances";
Real Ui(unit = "Btu/hr.ft^2.degF") "Overall Heat Transfer Coefficient based on the inside area Ai";
Real Qi(unit = "Btu/hr") "Rate of heat transfer based on Ui";
//===============================================================================================
//Equation Section
equation
ri = di/(2*12); //1 ft = 12 inch
r1 = d1/(2*12);
ro = do/(2*12);
Ai = 2*3.14*ri*L;
A1 = 2*3.14*r1*L;
Ao = 2*3.14*ro*L;
AA_lm = (A1-Ai)/log(A1/Ai);
AB_lm = (Ao-A1)/log(Ao/A1);
Ri = 1/(hi*Ai);
RA = (r1-ri)/(K_metal*AA_lm);
RB = (ro-r1)/(K_lagging*AB_lm);
Ro = 1/(ho*Ao);
Q = (Ti-To)/(Ri+RA+RB+Ro);
sigmaR = Ri+RA+RB+Ro;
Ui = 1/(Ai*sigmaR);
Qi = Ui*Ai*(Ti-To);
end Ex9_5;
