model Ex9_8
//Parameter Section
parameter Real r(unit = "m") = 2.54*10^(-3) "Radius of the stainless steel wire";
parameter Real I(unit = "A") = 250 "Electric current";
parameter Real L(unit = "m") = 2.448 "Length of the wire";
parameter Real R(unit = "ohm") = 0.0843 "Resistance offered by the wire";
parameter Real Tw(unit = "K") = 427.6 "Outer surface temperature of the wire";
parameter Real K(unit = "W/m.K") = 22.5 "Average thermal conductivity of the wire";
//===================================================================================
//Variable Section
Real Se(unit = "W/m^3") "Heat generated per unit volume";
Real Tmax(unit = "K") "Centreline Temperature";
//===================================================================================
//Equation Section
equation
Se = (I^2*R)/(3.14*r^2*L);
Tmax-Tw = ((Se*r^2)/(4*K));
end Ex9_8;
