model Ex11_3
//Parameter Section
parameter Real mu(unit = "N.s/m^2") = 0.6209*10^(-3) "Viscosity of water at 43.3 C";
parameter Real K(unit = "W/m.K") = 0.6291 "Thermal conductivity of water at 43.3 C";
parameter Real Cp(unit = "J/kg.K") = 3.768*10^3 "Specific heat of water at 43.3 C";
parameter Real w(unit = "kg/s") = 1.887 "Mass flow rate of water";
parameter Real D(unit = "m") = 5.08*10^(-2) "Inside diameter of the tube";
parameter Real L(unit = "m") = 1 "Length of the tube";
parameter Real Tb(unit = "C") = 15.5 "Temperature of the bulk fluid";
parameter Real Tw(unit = "C") = 71.11 "Temperature of the inner wall";
//=========================================================================================
//Variable Section
Real Pr(unit = "nil") "Prandtl number";
Real Re(unit = "nil") "Reynolds number";
Real h_loc(unit = "W/m^2.K") "Local heat transfer coefficient";
Real q_loc(unit = "W/m^2") "Local Heat flux";
Real A(unit = "m^2") "Area of heat transfer";
Real Q(unit = "W") "Heat transfer rate";
//=========================================================================================
//Equation Section
equation
Pr = (Cp*mu)/K;
Re = (4*w)/(3.14*D*mu);
(h_loc*D)/K = 5+(0.025*(Pr*Re)^0.8);
q_loc = -(h_loc*(Tw-Tb));
A = 3.14*D*L;
Q = q_loc*A;
end Ex11_3;
//The answer may slightly vary due to rounding off values
