model Ex12_3
//Parameter Section
parameter Real sigma(unit = "W/m^2.C^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
parameter Real D(unit = "inch") = 6 "Diameter of the insulation";
parameter Real T1(unit = "C") = 37.7 "Temperature of the outer surface of the insulation";
parameter Real T2(unit = "C") = 26.6 "Temperature of the surrounding walls and air in the room";
parameter Real e1(unit = "nil") = 0.93 "Emmisivity factor for asbestos paper";
parameter Real a1(unit = "nil") = 0.93 "Absorptivity factor for asbestos paper";
//===================================================================================================
//Variable Section
Real A1(unit = "m^2") "Area of the pipe";
Real Q12(unit = "W") "Total rate of heat loss";
//===================================================================================================
//Equation Section 
equation 
A1 = 3.14*D*2.54*10^(-2);
Q12 = sigma*A1*((e1*(T1+273)^4)-(a1*(T2+273)^4));
end Ex12_3;
